<?php
/**
 * GameCS-Bot • by bot1 Setup Wizard v1.1 (fixed)
 * - создаёт config.php
 * - создаёт служебные таблицы (steam_links, tg_warns, tg_mutes)
 * - кладёт значения по умолчанию в bot_settings
 * - помогает активировать webhook
 */
error_reporting(0);
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('Europe/Kiev');

if (file_exists(__DIR__.'/config.php')) {
  echo "<meta charset='utf-8'><body style='background:#0f1220;color:#fff;font-family:Inter,system-ui,sans-serif;text-align:center;padding:80px'>
  <h1>⚙️ GameCS-Bot уже установлен</h1>
  <p>Удалите <code>config.php</code>, чтобы запустить мастер снова.</p>
  <a href='admin.php' style='display:inline-block;margin-top:20px;padding:10px 20px;border-radius:8px;background:#5561ff;color:#fff;text-decoration:none'>Перейти в админ-панель</a></body>";
  exit;
}

function test_mysql($h,$u,$p,$n){
  $c=@mysqli_connect($h,$u,$p,$n);
  if(!$c) return mysqli_connect_error();
  mysqli_close($c); return true;
}
function test_token($t){
  $res=@file_get_contents("https://api.telegram.org/bot{$t}/getMe");
  if(!$res) return "нет ответа";
  $j=@json_decode($res,true);
  if(!$j || !$j['ok']) return "ошибка: ".($j['description']??'неизвестно');
  return true;
}

if($_SERVER['REQUEST_METHOD']==='POST'){
  $token = trim($_POST['token']);
  $host  = trim($_POST['db_host']);
  $user  = trim($_POST['db_user']);
  $pass  = trim($_POST['db_pass']);
  $name  = trim($_POST['db_name']);
  $ip    = trim($_POST['server_ip']);
  $port  = trim($_POST['server_port']);
  $domain= rtrim(trim($_POST['domain']),'/');
  $path  = '/'.trim($_POST['webhook_path'],'/');
  $head  = preg_replace('~\s+~','',trim($_POST['head_admins']?:''));
  $panel = trim($_POST['admin_pass']);

  $err='';
  if(strlen($token)<10) $err.='⚠️ Укажите корректный токен<br>';
  $mysql = test_mysql($host,$user,$pass,$name);
  if($mysql!==true) $err.="⚠️ Ошибка MySQL: $mysql<br>";
  $check = test_token($token);
  if($check!==true) $err.="⚠️ Ошибка токена: $check<br>";
  if(!$panel) $err.="⚠️ Задайте пароль админ-панели<br>";
  if(!$domain) $err.="⚠️ Укажите домен<br>";

  if(!$err){
    // config.php
    $cfg = <<<PHP
<?php
// Сгенерировано install.php
\$CFG = [
  'bot_token' => '{$token}',
  'db' => [
    'host' => '{$host}',
    'user' => '{$user}',
    'pass' => '{$pass}',
    'name' => '{$name}',
  ],
  'head_admins' => [{$head}],
  'default_lang' => 'ru',
  'admin_panel_password' => '{$panel}',
  'domain' => '{$domain}',
  'webhook_path' => '{$path}',
  'http_timeout' => 5,
];
PHP;
    file_put_contents(__DIR__.'/config.php',$cfg);

    // Таблицы
    $c=@mysqli_connect($host,$user,$pass,$name);
    mysqli_set_charset($c,'utf8mb4');
    $sqls = [
"CREATE TABLE IF NOT EXISTS bot_settings (`key` VARCHAR(64) PRIMARY KEY, `value` TEXT NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
"CREATE TABLE IF NOT EXISTS steam_links (tg_id BIGINT PRIMARY KEY, steamid VARCHAR(64), username VARCHAR(64), updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
"CREATE TABLE IF NOT EXISTS tg_warns (chat_id BIGINT, tg_id BIGINT, warns INT DEFAULT 0, PRIMARY KEY(chat_id,tg_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
"CREATE TABLE IF NOT EXISTS tg_mutes (chat_id BIGINT, tg_id BIGINT, until_ts INT DEFAULT 0, PRIMARY KEY(chat_id,tg_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;"
    ];
    foreach($sqls as $q) mysqli_query($c,$q);

    // Дефолтные настройки
    $def = [
      'lang'=>'ru',
      'banner_url'=>'', // можно поставить ссылку на баннер
      'welcome_ru'=>'👋 Добро пожаловать, {name}! Приятной игры 🎮',
      'welcome_ua'=>'👋 Ласкаво просимо, {name}! Приємної гри 🎮',
      'server_ip'=>$ip?:'IP сервера',
      'server_port'=>$port?:'Порт сервера',
      'phrase_help'=>"📚 <b>Справка</b>\n/me — ваша статистика\n/yu — статистика пользователя (ответом)\n/play_НИК — поиск по нику\n/top_kill — топ по убийствам\n/top_anew — топ по бонусам\n/top_time — топ по времени\n/top10 — общий рейтинг (киллы-смерти)\n/online — кто на сервере\n/info — инфо сервера\n/myid — ваш Telegram ID\n/yuid — ID другого (ответом)\n/setsteam STEAM_1:0:123456 — привязка Steam\n\nАдминам: /warn /unwarn /ban /unban /mute /unmute /silence on|off /status",
      'phrase_menu'=>"📋 <b>Главное меню</b>\nВыберите действие:",
      'phrase_me_title'=>'🎯 Ваша статистика',
      'phrase_online'=>'🖥 Состояние сервера'
    ];
    foreach($def as $k=>$v){
      $k=mysqli_real_escape_string($c,$k);
      $v=mysqli_real_escape_string($c,$v);
      mysqli_query($c,"INSERT IGNORE INTO bot_settings(`key`,`value`) VALUES('$k','$v')");
    }
    mysqli_close($c);

    $hookUrl = $domain.$path;
    echo "<meta charset='utf-8'><body style='background:#0f1220;color:#fff;font-family:Inter,system-ui,sans-serif;display:grid;place-items:center;min-height:100vh'>
    <div style='background:#151832;padding:28px;border-radius:18px;border:1px solid #2a2f55;max-width:680px'>
      <h1 style='margin:0 0 12px;color:#10b981'>✅ GameCS-Bot установлен</h1>
      <p>Теперь можно активировать вебхук и перейти в панель.</p>
      <div style='display:flex;gap:10px;flex-wrap:wrap;margin-top:10px'>
        <a href='https://api.telegram.org/bot{$token}/setWebhook?url=".urlencode($hookUrl)."' target='_blank' style='padding:10px 16px;border-radius:10px;background:#5561ff;color:#fff;text-decoration:none'>🔗 Активировать вебхук</a>
        <a href='admin.php' style='padding:10px 16px;border-radius:10px;background:#10b981;color:#fff;text-decoration:none'>⚙️ Открыть admin.php</a>
      </div>
      <p style='color:#9aa4d2;margin-top:14px;font-size:13px'>Вебхук URL: <code>{$hookUrl}</code></p>
    </div></body>";
    exit;
  } else {
    $fail = $err;
  }
}
?>
<!doctype html><html lang="ru"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>GameCS-Bot • Установка</title>
<style>
:root{--bg:#0f1220;--panel:#151832;--border:#2a2f55;--text:#fff;--muted:#9aa4d2;--acc:#5561ff;--acc2:#8b5cf6}
*{box-sizing:border-box}
body{background:var(--bg);color:var(--text);font-family:Inter,system-ui,sans-serif;margin:0;display:grid;place-items:center;min-height:100vh;padding:20px}
form{background:var(--panel);border:1px solid var(--border);border-radius:18px;padding:24px;width:min(760px,96vw)}
h1{margin:0 0 14px;color:#8b5cf6;font-size:26px}
.grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
@media(max-width:720px){.grid{grid-template-columns:1fr}}
label{font-size:13px;color:#cfd8ff}
input{width:100%;margin-top:6px;padding:12px 14px;border-radius:10px;border:1px solid #333a70;background:#12142a;color:#fff}
button{margin-top:18px;width:100%;padding:14px;border:0;border-radius:12px;background:linear-gradient(135deg,var(--acc),var(--acc2));color:#fff;font-size:15px;font-weight:600;cursor:pointer}
.note{color:var(--muted);font-size:13px;margin-top:10px}
.alert{background:#311;color:#f66;padding:12px;border-radius:10px;margin-bottom:12px}
</style></head>
<body>
<form method="post" autocomplete="off">
  <h1>GameCS-Bot • Setup Wizard</h1>
  <?php if(!empty($fail)) echo "<div class='alert'>{$fail}</div>"; ?>
  <div class="grid">
    <div><label>🤖 Telegram Bot Token<input name="token" required placeholder="123456:ABC..."></label></div>
    <div><label>👑 TG ID главных админов (через запятую)<input name="head_admins" placeholder="6024636965,989468013"></label></div>

    <div><label>🧠 MySQL Host<input name="db_host" value="127.0.0.1" required></label></div>
    <div><label>👤 MySQL User<input name="db_user" required></label></div>
    <div><label>🔑 MySQL Pass<input name="db_pass" type="password"></label></div>
    <div><label>📁 MySQL DB Name<input name="db_name" required></label></div>

    <div><label>🕹 IP сервера<input name="server_ip" value="IP сервера"></label></div>
    <div><label>⚙️ Порт сервера<input name="server_port" value="PORT"></label></div>

    <div><label>🌐 Домен (с https://)<input name="domain" placeholder="https://example.com" required></label></div>
    <div><label>📄 Путь к bot.php (вебхук)<input name="webhook_path" value="/GameCS-Bot/bot.php" required></label></div>

    <div><label>🔒 Пароль admin.php<input name="admin_pass" type="password" required></label></div>
  </div>

  <button>🚀 Установить</button>
  <p class="note">Будут созданы: <code>config.php</code>, таблицы <code>bot_settings</code>, <code>steam_links</code>, <code>tg_warns</code>, <code>tg_mutes</code>.</p>
</form>
</body></html>
