<?php
session_start();
require_once __DIR__.'/config.php';

// DB
function db() {
  global $CFG;
  static $pdo=null;
  if($pdo) return $pdo;
  $dsn="mysql:host={$CFG['db']['host']};dbname={$CFG['db']['name']};charset=utf8mb4";
  $pdo=new PDO($dsn,$CFG['db']['user'],$CFG['db']['pass'],[
    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC,
  ]);
  return $pdo;
}
function settings_load() {
  $st=db()->query("SELECT `key`,`value` FROM bot_settings");
  $out=[]; foreach($st as $r){ $out[$r['key']]=$r['value']; }
  return $out;
}
function settings_set($k,$v){
  $st=db()->prepare("INSERT INTO bot_settings (`key`,`value`) VALUES (:k,:v) ON DUPLICATE KEY UPDATE `value`=VALUES(`value`)");
  $st->execute([':k'=>$k,':v'=>$v]);
}
function esc($s){ return htmlspecialchars((string)$s,ENT_QUOTES|ENT_SUBSTITUTE,'UTF-8'); }

$S = settings_load();
$lang = $S['lang'] ?? $CFG['default_lang'];

// login
if(isset($_POST['login'])){
  if(hash('sha256',$_POST['pass'])===hash('sha256',$CFG['admin_panel_password'])){
    $_SESSION['admin_ok']=true;
    header("Location: admin.php"); exit;
  } else $error="Неверный пароль";
}
if(isset($_GET['logout'])){ session_destroy(); header("Location: admin.php"); exit; }

if(!($_SESSION['admin_ok']??false)){
  ?><!doctype html><html lang="ru"><head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>GameCS-Bot • Admin</title>
  <style>
  :root{--bg:#0f1220;--panel:#151832;--border:#2a2f55;--muted:#9aa4d2;--acc:#5561ff;--ok:#10b981}
  *{box-sizing:border-box} body{background:var(--bg);color:#fff;font-family:Inter,sans-serif;display:grid;place-items:center;min-height:100vh;margin:0}
  form{background:var(--panel);border:1px solid var(--border);border-radius:18px;padding:26px;width:min(420px,92vw)}
  h1{margin:0 0 12px;color:#8b5cf6;font-size:22px}
  input{width:100%;padding:12px;border-radius:10px;border:1px solid #333a70;background:#12142a;color:#fff}
  button{margin-top:12px;width:100%;padding:12px;border:0;border-radius:10px;background:linear-gradient(135deg,#5561ff,#8b5cf6);color:#fff;font-weight:600}
  .err{background:#311;color:#f66;padding:10px;border-radius:8px;margin-bottom:10px}
  </style></head><body>
  <form method="post">
    <h1>GameCS-Bot • Admin</h1>
    <?php if(!empty($error)) echo "<div class='err'>".esc($error)."</div>"; ?>
    <input name="pass" type="password" placeholder="Пароль админ-панели" required>
    <button name="login">Войти</button>
  </form></body></html><?php
  exit;
}

// save
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save'])){
  if(isset($_POST['lang']) && $_POST['lang']!=$S['lang']){
    $head_confirm = trim($_POST['head_confirm']??'');
    $is_head = in_array((int)$head_confirm, $CFG['head_admins'], true);
    if($is_head){
      settings_set('lang', $_POST['lang']==='ua'?'ua':'ru');
      $S['lang']=$_POST['lang']==='ua'?'ua':'ru';
      $msg="Сохранено (язык обновлён)";
    } else {
      $msg="Язык не изменён: требуется TG ID главного админа.";
    }
  }
  $keys = ['banner_url','welcome_ru','welcome_ua','server_ip','server_port','phrase_help','phrase_menu','phrase_me_title','phrase_online'];
  foreach($keys as $k){ if(isset($_POST[$k])){ settings_set($k, $_POST[$k]); $S[$k]=$_POST[$k]; } }
  $msg = ($msg??'')." Настройки сохранены.";
}

// webhook
$hook_status=null;
if(isset($_POST['do_webhook'])){
  $hook = rtrim($CFG['domain'],'/').$CFG['webhook_path'];
  $url = "https://api.telegram.org/bot{$CFG['bot_token']}/setWebhook?url=".urlencode($hook);
  $hook_status = @file_get_contents($url);
}

?><!doctype html><html lang="ru"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>GameCS-Bot • Admin</title>
<style>
:root{--bg:#0f1220;--panel:#151832;--border:#2a2f55;--muted:#9aa4d2;--acc:#5561ff;--acc2:#8b5cf6;--ok:#10b981}
*{box-sizing:border-box}
body{background:var(--bg);color:#fff;font-family:Inter,system-ui,sans-serif;margin:0;min-height:100vh}
.container{max-width:1100px;margin:28px auto;padding:0 16px}
.topbar{display:flex;align-items:center;justify-content:space-between;margin-bottom:16px}
.badge{padding:6px 10px;border-radius:999px;background:#1e223f;border:1px solid var(--border);color:#cfd8ff;font-size:13px}
.card{background:var(--panel);border:1px solid var(--border);border-radius:18px;padding:18px;margin-bottom:16px}
h1{margin:0 0 10px;color:#8b5cf6}
h2{margin:0 0 12px;color:#cfd8ff;font-size:18px}
.grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
@media(max-width:920px){.grid{grid-template-columns:1fr}}
label{font-size:13px;color:#cfd8ff}
input,textarea,select{width:100%;padding:12px;border-radius:10px;border:1px solid #333a70;background:#12142a;color:#fff}
textarea{min-height:92px}
.btn{padding:10px 14px;border-radius:10px;border:0;background:linear-gradient(135deg,var(--acc),var(--acc2));color:#fff;font-weight:600;cursor:pointer}
.btn2{padding:10px 14px;border-radius:10px;border:1px solid var(--border);background:#1b1f3b;color:#cfd8ff;cursor:pointer}
.row{display:flex;gap:10px;flex-wrap:wrap}
.msg{background:#0d3228;border:1px solid #135c47;color:#caffea;padding:10px;border-radius:10px;margin-bottom:12px}
.note{color:#9aa4d2;font-size:13px}
.kv{display:grid;grid-template-columns:220px 1fr;gap:10px;align-items:center}
@media(max-width:640px){.kv{grid-template-columns:1fr}}
</style></head>
<body>
<div class="container">
  <div class="topbar">
    <div class="row">
      <span class="badge">GameCS-Bot Admin</span>
      <span class="badge">Язык: <?=esc($S['lang']??'ru')?></span>
      <span class="badge">TG-бот: <?=substr($CFG['bot_token'],0,8)?>…</span>
    </div>
    <a class="btn2" href="?logout=1">Выйти</a>
  </div>

  <?php if(!empty($msg)) echo "<div class='msg'>".esc($msg)."</div>"; ?>

  <form method="post" class="card">
    <h2>⚙️ Основные</h2>
    <div class="grid">
      <div class="kv"><label>Язык бота (RU/UA)</label>
        <div class="row">
          <select name="lang">
            <option value="ru" <?=($S['lang']??'ru')==='ru'?'selected':''?>>Русский</option>
            <option value="ua" <?=($S['lang']??'ru')==='ua'?'selected':''?>>Українська</option>
          </select>
          <input name="head_confirm" placeholder="TG ID главного админа для смены языка">
        </div>
      </div>

      <div class="kv"><label>URL баннера (png/jpg)</label>
        <input name="banner_url" value="<?=esc($S['banner_url']??'')?>" placeholder="https://.../banner.jpg">
      </div>

      <div class="kv"><label>IP сервера</label>
        <input name="server_ip" value="<?=esc($S['server_ip']??'91.211.118.88')?>">
      </div>
      <div class="kv"><label>Порт сервера</label>
        <input name="server_port" value="<?=esc($S['server_port']??'27055')?>">
      </div>

      <div class="kv"><label>Приветствие RU</label>
        <textarea name="welcome_ru"><?=esc($S['welcome_ru']??'👋 Добро пожаловать, {name}!')?></textarea>
      </div>
      <div class="kv"><label>Приветствие UA</label>
        <textarea name="welcome_ua"><?=esc($S['welcome_ua']??'👋 Ласкаво просимо, {name}!')?></textarea>
      </div>

      <div class="kv"><label>Текст /help</label>
        <textarea name="phrase_help"><?=esc($S['phrase_help']??'')?></textarea>
      </div>
      <div class="kv"><label>Заголовок меню</label>
        <textarea name="phrase_menu"><?=esc($S['phrase_menu']??'')?></textarea>
      </div>
      <div class="kv"><label>Заголовок /me</label>
        <input name="phrase_me_title" value="<?=esc($S['phrase_me_title']??'🎯 Ваша статистика')?>">
      </div>
      <div class="kv"><label>Заголовок /online</label>
        <input name="phrase_online" value="<?=esc($S['phrase_online']??'🖥 Состояние сервера')?>">
      </div>
    </div>

    <div class="row" style="margin-top:10px">
      <button class="btn" name="save">💾 Сохранить</button>
      <span class="note">Домен и путь к bot.php редактируются в <code>config.php</code>: <b><?=esc($CFG['domain'].$CFG['webhook_path'])?></b></span>
    </div>
  </form>

  <form method="post" class="card">
    <h2>🔗 Вебхук</h2>
    <div class="row" style="align-items:center">
      <div class="note">URL: <code><?=esc(rtrim($CFG['domain'],'/').$CFG['webhook_path'])?></code></div>
      <button class="btn" name="do_webhook">Активировать / Переустановить webhook</button>
    </div>
    <?php if($hook_status){ echo "<pre style='background:#0b0e22;padding:10px;border-radius:10px;overflow:auto;margin-top:10px'>".esc($hook_status)."</pre>"; } ?>
  </form>

  <div class="card">
    <h2>ℹ️ Подсказки</h2>
    <ul class="note">
      <li>Ставьте бота админом в группе (право на бан/мут/изменение прав).</li>
      <li>Статистика берётся из таблицы <code>csstats_players</code> вашей БД CSStatsX.</li>
      <li>Команды админа: /warn /unwarn /ban /unban /mute /unmute /silence on|off /status</li>
    </ul>
  </div>
</div>
</body></html>
